/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf;

import com.ibm.hwmca.base.rsf.RsfRequestInfo;
import com.ibm.hwmca.base.rsf.RsfRequestsConstants;
import com.ibm.hwmca.base.rsf.RsfRequestsErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class RsfRequestsBean
extends PanelBean
implements RsfRequestsConstants,
RsfRequestsErrorIds {
    private static final String TRACEMASK_T = "XRSFBENT";
    private static final String TRACEMASK_F = "XRSFBENF";
    private static final String TRACEMASK_D = "XRSFBEND";
    public static final int ATABLE_NUMCOLS = 5;
    public static final int WTABLE_NUMCOLS = 3;
    private List activeTable;
    private int[] activeTableSelection;
    private List activeRequestIds;
    private List waitingTable;
    private int[] waitingTableSelection;
    private List waitingRequestIds;
    private FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RSFBean");

    public int getActiveTableRowStatus() {
        Trace.trace(TRACEMASK_D, "<--> getActiveTableRowStatus() (return: 3)");
        return 3;
    }

    public int getActiveTableRowCount() {
        Trace.trace(TRACEMASK_D, "<--> getActiveTableRowCount() (return: " + this.activeTable.size() + ")");
        return this.activeTable.size();
    }

    public ItemDescriptor[] getActiveTableRowAt(int index) {
        Trace.trace(TRACEMASK_D, "<--> getActiveTableRowAt(" + index + ")");
        boolean isValidIndex = index >= 0 && index < this.activeTable.size();
        StringBuffer trace = new StringBuffer("active requests table row at " + index + ": ");
        if (isValidIndex) {
            trace.append(this.arrayToString((ItemDescriptor[])this.activeTable.get(index)));
        } else {
            trace.append("does not exist");
        }
        Trace.trace(TRACEMASK_D, trace.toString());
        if (isValidIndex) {
            return (ItemDescriptor[])this.activeTable.get(index);
        }
        return null;
    }

    public void setActiveTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getActiveTableSelection() {
        Trace.trace(TRACEMASK_D, "<--> getActiveTableSelection() (return: " + this.arrayToString(this.activeTableSelection) + ")");
        return this.activeTableSelection;
    }

    public void setActiveTableSelection(int[] selected) {
        Trace.trace(TRACEMASK_D, "<--> setActiveTableSelection(" + this.arrayToString(selected) + ")");
        this.activeTableSelection = selected;
    }

    public int getWaitingTableRowStatus() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingTableRowStatus() (return: 3)");
        return 3;
    }

    public int getWaitingTableRowCount() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingTableRowCount() (return: " + this.waitingTable.size() + ")");
        return this.waitingTable.size();
    }

    public ItemDescriptor[] getWaitingTableRowAt(int index) {
        Trace.trace(TRACEMASK_D, "<--> getWaitingTableRowAt(" + index + ")");
        boolean isValidIndex = index >= 0 && index < this.waitingTable.size();
        StringBuffer trace = new StringBuffer("waiting requests table row at " + index + ": ");
        if (isValidIndex) {
            trace.append(this.arrayToString((ItemDescriptor[])this.waitingTable.get(index)));
        } else {
            trace.append("does not exist");
        }
        Trace.trace(TRACEMASK_D, trace.toString());
        if (isValidIndex) {
            return (ItemDescriptor[])this.waitingTable.get(index);
        }
        return null;
    }

    public void setWaitingTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getWaitingTableSelection() {
        Trace.trace(TRACEMASK_D, "<--> getWaitingTableSelection() (return: " + this.arrayToString(this.waitingTableSelection) + ")");
        return this.waitingTableSelection;
    }

    public void setWaitingTableSelection(int[] selected) {
        Trace.trace(TRACEMASK_D, "<--> setWaitingTableSelection(" + this.arrayToString(selected) + ")");
        this.waitingTableSelection = selected;
    }

    public void setQueues(List[] requests) {
        Trace.trace(TRACEMASK_T, "--> setQueues(" + this.arrayToString(requests) + ")");
        try {
            this.activeTable = requests[0];
            this.waitingTable = requests[1];
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in setQueues()!  Error logged and closing panel!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- setQueues()");
    }

    public void verifyChanges() {
        Trace.trace(TRACEMASK_D, "<--> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACEMASK_D, "<--> save()");
    }

    public void load() {
        Trace.trace(TRACEMASK_T, "--> load()");
        RsfRequestInfo request = null;
        ListIterator info = null;
        try {
            this.activeTableSelection = new int[0];
            this.waitingTableSelection = new int[0];
            info = this.activeTable.listIterator();
            this.activeTable = new ArrayList();
            this.activeRequestIds = new ArrayList();
            while (info.hasNext()) {
                request = (RsfRequestInfo)info.next();
                this.activeRequestIds.add(request.getId());
                this.activeTable.add(this.buildQueueEntry(request, 5));
            }
            info = this.waitingTable.listIterator();
            this.waitingTable = new ArrayList();
            this.waitingRequestIds = new ArrayList();
            while (info.hasNext()) {
                request = (RsfRequestInfo)info.next();
                this.waitingRequestIds.add(request.getId());
                this.waitingTable.add(this.buildQueueEntry(request, 3));
            }
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in load()!  Error logged and closing panel!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- load()");
    }

    public void update(Object obj) {
        Trace.trace(TRACEMASK_T, "--> update(<List of Maps>)");
        int listLength = 0;
        int position = 0;
        RsfRequestInfo request = null;
        Map updateInfo = null;
        Object requestId = null;
        String updateType = null;
        List updateList = null;
        try {
            updateList = (List)obj;
            listLength = updateList.size();
            int i = 0;
            while (i < listLength) {
                updateInfo = (Map)updateList.get(i);
                updateType = (String)updateInfo.get("updateType");
                request = (RsfRequestInfo)updateInfo.get("requestObject");
                Trace.trace(TRACEMASK_F, "panel update info (Map): " + updateInfo);
                if (updateType.equals("activeRequestChanged")) {
                    position = this.findQueueEntry(this.activeRequestIds, request.getId());
                    this.deleteQueueEntry(this.activeTable, this.activeRequestIds, position);
                    this.insertQueueEntry(this.activeTable, this.buildQueueEntry(request, 5), this.activeRequestIds, request.getId(), position);
                } else if (updateType.equals("addedToWaiting")) {
                    this.insertQueueEntry(this.waitingTable, this.buildQueueEntry(request, 3), this.waitingRequestIds, request.getId(), this.waitingTable.size());
                } else if (updateType.equals("movedFromWaitingToActive")) {
                    position = this.findQueueEntry(this.waitingRequestIds, request.getId());
                    if (position >= 0) {
                        this.deleteQueueEntry(this.waitingTable, this.waitingRequestIds, position);
                    }
                    this.insertQueueEntry(this.activeTable, this.buildQueueEntry(request, 5), this.activeRequestIds, request.getId(), this.activeTable.size());
                } else if (updateType.equals("removedFromActive")) {
                    position = this.findQueueEntry(this.activeRequestIds, request.getId());
                    if (position >= 0) {
                        this.deleteQueueEntry(this.activeTable, this.activeRequestIds, position);
                    }
                } else if (updateType.equals("removedFromWaiting") && (position = this.findQueueEntry(this.waitingRequestIds, request.getId())) >= 0) {
                    this.deleteQueueEntry(this.waitingTable, this.waitingRequestIds, position);
                }
                ++i;
            }
            this.userTaskManager.refreshAllElements();
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in update()!  Error logged!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- update()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACEMASK_T, "--> panelAction(" + event + ")");
        String[] selectedRequestIds = null;
        PanelTaskletRequest request = null;
        String elementName = null;
        try {
            this.userTaskManager.storeElement("ActiveTable");
            this.userTaskManager.storeElement("WaitingTable");
            request = new PanelTaskletRequest();
            request.setSource(this.getBeanName());
            elementName = event.getElementName();
            if (elementName.endsWith("ViewCallHomeItem")) {
                request.setData("command", "ViewCallHomeItem");
            } else if (elementName.endsWith("CancelSelectedItem")) {
                selectedRequestIds = new String[this.activeTableSelection.length + this.waitingTableSelection.length];
                int i = 0;
                while (i < this.activeTableSelection.length) {
                    selectedRequestIds[i] = (String)this.activeRequestIds.get(this.activeTableSelection[i]);
                    ++i;
                }
                int j = i;
                i = 0;
                while (i < this.waitingTableSelection.length) {
                    selectedRequestIds[j++] = (String)this.waitingRequestIds.get(this.waitingTableSelection[i]);
                    ++i;
                }
                request.setData("requestids", selectedRequestIds);
                request.setData("command", "CancelRequests");
            } else if (elementName.endsWith("CancelActiveItem")) {
                request.setData("requestids", this.listToArrayOfStrings(this.activeRequestIds));
                request.setData("command", "CancelRequests");
            } else if (elementName.endsWith("CancelWaitingItem")) {
                request.setData("requestids", this.listToArrayOfStrings(this.waitingRequestIds));
                request.setData("command", "CancelRequests");
            } else if (elementName.endsWith("ExitItem")) {
                request.setDisposed();
            } else if (event.getActionCommand().equals("CANCEL")) {
                request.setCanceled();
            } else {
                throw new Exception("Unknown action or element generated event!");
            }
            this.postTaskletRequest(request);
            this.userTaskManager.refreshAllElements();
        }
        catch (IllegalUserDataException iudEx) {
            throw iudEx;
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in panelAction()!  Error logged!");
            new FrameworkLog(this.logInfo, 5, ex).log();
            this.dispose();
        }
        Trace.trace(TRACEMASK_T, "<-- panelAction()");
    }

    private String arrayToString(int[] array) {
        Trace.trace(TRACEMASK_D, "<-> arrayToString(<int[]>)");
        StringBuffer buffer = new StringBuffer("{ ");
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i]);
            if (i < array.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private String arrayToString(Object[] array) {
        Trace.trace(TRACEMASK_D, "<-> arrayToString(<Object[]>)");
        StringBuffer buffer = new StringBuffer("{ ");
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i]);
            if (i < array.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private String[] listToArrayOfStrings(List strings) {
        Trace.trace(TRACEMASK_D, "<-> vectorToArrayOfStrings(" + strings + ")");
        String[] stringArray = new String[strings.size()];
        int i = 0;
        while (i < stringArray.length) {
            stringArray[i] = (String)strings.get(i);
            ++i;
        }
        return stringArray;
    }

    private ItemDescriptor[] buildQueueEntry(RsfRequestInfo request, int numCols) {
        Trace.trace(TRACEMASK_T, "-> buildQueueEntry(" + request + ", " + numCols + ")");
        int index = 0;
        ItemDescriptor[] queueEntry = null;
        queueEntry = new ItemDescriptor[numCols];
        if (numCols == 5) {
            queueEntry[index] = new ItemDescriptor(null, request.getState());
            queueEntry[++index] = new ItemDescriptor(null, request.getCallHomeServer());
            ++index;
        }
        queueEntry[index] = new DateItemDescriptor(null, request.getDate());
        queueEntry[++index] = new TimeItemDescriptor(null, request.getDate());
        queueEntry[++index] = new ItemDescriptor(null, request.getDescription());
        Trace.trace(TRACEMASK_T, "<- buildQueueEntry() (return: " + queueEntry + ")");
        return queueEntry;
    }

    private void deleteQueueEntry(List table, List idList, int position) {
        Trace.trace(TRACEMASK_T, "-> deleteQueueEntry(<queue table>, " + this.arrayToString(idList.toArray()) + ", " + position + ")");
        table.remove(position);
        idList.remove(position);
        Trace.trace(TRACEMASK_T, "<- deleteQueueEntry()");
    }

    private int findQueueEntry(List idList, String id) {
        Trace.trace(TRACEMASK_T, "<-> findQueueEntry(" + this.arrayToString(idList.toArray()) + ", " + id + ")");
        int index = 0;
        while (index < idList.size()) {
            if (idList.get(index).equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void insertQueueEntry(List table, ItemDescriptor[] row, List idList, String id, int position) {
        Trace.trace(TRACEMASK_T, "-> insertQueueEntry(<queue table>, " + this.arrayToString(row) + ", " + this.arrayToString(idList.toArray()) + ", " + id + ", " + position + ")");
        table.add(position, row);
        idList.add(position, id);
        Trace.trace(TRACEMASK_T, "<- insertQueueEntry()");
    }
}

